/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

#include "mx_auto_config.h"
#include "myriexpress.h"
#if !MX_OS_WINNT
#include <arpa/inet.h>
#endif

#include <stddef.h>
#include <stdio.h>

#include "mx__lib_types.h"
#include "mx__mcp_request_ring.h"

char *forge_event(char *eventq, int length, char *bottom, uint32_t data,
		  uint8_t frag_seqnum, uint16_t msg_seqnum,
		  uint32_t msg_length)
{
#if 0
  mcp_uevt_recv_t *e;
  uint32_t *f;

  char *page_top;

  d = (mcp_uevt_recv_data_t*)(bottom - sizeof (*d));
  f = (uint32_t*)((char*)d - 4);
  e = (mcp_uevt_recv_eager_t*)((char*)d - 4 - sizeof (*e));

  d->evt_length = ntohs(sizeof (*e) + 4 + sizeof (*d));
  d->status = MX_STATUS_SUCCESS;
  d->type = MX_MCP_UEVT_RECV_MEDIUM;

  *f = data;
  
  e->frag_length = ntohs(4);
  e->frag_seqnum = frag_seqnum;
  e->recvq_offset = 0
  e->frag_pipeline_log = 2;
  e->msg_seqnum = ntohs(msg_seqnum);
  e->match_b = 0;
  e->match_a = 0;
  e->msg_length = htonl(msg_length);
  e->source_magic = 0;
  e->source_endpt = 0;
  e->source_peer_index = 0;
  e->source_mac = 0;
  
  bottom = (char*)&e->source_mac_a;

  page_top = (char*)((uintptr_t)(bottom-1) & ~(4096-1));
  if ((bottom - page_top) < MX_MCP_MAX_EVENT_SIZE) {
    bottom = page_top;
    if (bottom-1 < eventq) {
      bottom = eventq+length;
    }
  }
#endif
  return bottom;
}  

int main(void)
{
  mx_endpoint_t ep;
  mx_segment_t rseg1;
  mx_segment_t rseg2;
  mx_request_t rreq1;
  mx_request_t rreq2;
  char rbuf1[80];
  char rbuf2[80];
  mx_status_t s;
  char *eventq;
  int length;
  char *bottom;
  uint32_t result;

  int i;

  mx_init();
  mx_set_error_handler(MX_ERRORS_RETURN);
  mx_open_endpoint(MX_ANY_NIC, 1, 0, NULL, 0, &ep);

  /* Make requestq off by one so that mcp never gets requests. */
  mx__get_ureq(ep->req_ring, 0);

  rseg1.segment_ptr = rbuf1;
  rseg1.segment_length = 80;
  mx_irecv(ep, &rseg1, 1, 0, MX_MATCH_MASK_NONE, NULL, &rreq1);
  rseg2.segment_ptr= rbuf2;
  rseg2.segment_length = 80;
  mx_irecv(ep, &rseg2, 1, 0, MX_MATCH_MASK_NONE, NULL, &rreq2);

  eventq = ep->eventq;
  length = ep->eventq_length;
  bottom = eventq + length;

  bottom = forge_event(eventq, length, bottom, 0x02, 0, 1, 4);
  bottom = forge_event(eventq, length, bottom, 0x01, 0, 0, 4);

  do {
    mx_test(ep, &rreq1, &s, &result);
  } while (result == 0);
  do {
    mx_test(ep, &rreq2, &s, &result);
  } while (result == 0);

  printf("rreq1 = ");
  for (i = 0; i < 8; ++i) {
    printf("%x ", (unsigned int)rbuf1[i]);
  }
  printf("\n");

  printf("rreq2 = ");
  for (i = 0; i < 8; ++i) {
    printf("%x ", (unsigned int)rbuf2[i]);
  }
  printf("\n");
    
  mx_close_endpoint(ep);
  mx_finalize();
  return 0;
}
